/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockSoulLily;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class SoulLilyFeature
extends ContextFeature<NoneFeatureConfiguration> {
    public SoulLilyFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        int RANDOM_BOUND = (int)(6.0f * scale_factor);
        if (world.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50135_) {
            int x = pos.m_123341_();
            int z = pos.m_123343_();
            int y = pos.m_123342_() + random.m_188503_(RANDOM_BOUND);
            for (int j = 0; j < RANDOM_BOUND; ++j) {
                context.POS.m_122178_(x, y - j, z);
                if (context.POS.m_123342_() <= 31) break;
                Block under = world.m_8055_(context.POS.m_7495_()).m_60734_();
                if (under != Blocks.f_50135_ || !world.m_46859_((BlockPos)context.POS)) continue;
                this.growTree(world, (BlockPos)context.POS, random);
            }
            return true;
        }
        return false;
    }

    private boolean growTree(ServerLevelAccessor world, BlockPos pos, RandomSource random) {
        if (world.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50135_) {
            if (world.m_46859_(pos.m_7494_())) {
                if (world.m_46859_(pos.m_6630_(2)) && this.isAirSides((LevelAccessor)world, pos.m_6630_(2))) {
                    this.growBig((LevelAccessor)world, pos);
                } else {
                    this.growMedium((LevelAccessor)world, pos);
                }
            } else {
                this.growSmall((LevelAccessor)world, pos);
            }
            return true;
        }
        return false;
    }

    public void growSmall(LevelAccessor world, BlockPos pos) {
        BlocksHelper.setWithUpdate(world, pos, NetherBlocks.SOUL_LILY.m_49966_());
    }

    public void growMedium(LevelAccessor world, BlockPos pos) {
        BlocksHelper.setWithUpdate(world, pos, (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.MEDIUM_BOTTOM)));
        BlocksHelper.setWithUpdate(world, pos.m_7494_(), (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.MEDIUM_TOP)));
    }

    public void growBig(LevelAccessor world, BlockPos pos) {
        BlocksHelper.setWithUpdate(world, pos, (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.BIG_BOTTOM)));
        BlocksHelper.setWithUpdate(world, pos.m_7494_(), (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.BIG_MIDDLE)));
        BlockPos up = pos.m_6630_(2);
        BlocksHelper.setWithUpdate(world, up, (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.BIG_TOP_CENTER)));
        BlocksHelper.setWithUpdate(world, up.m_122012_(), (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.BIG_TOP_SIDE_S)));
        BlocksHelper.setWithUpdate(world, up.m_122019_(), (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.BIG_TOP_SIDE_N)));
        BlocksHelper.setWithUpdate(world, up.m_122029_(), (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.BIG_TOP_SIDE_W)));
        BlocksHelper.setWithUpdate(world, up.m_122024_(), (BlockState)NetherBlocks.SOUL_LILY.m_49966_().m_61124_(BlockSoulLily.SHAPE, (Comparable)((Object)BlockSoulLily.SoulLilyShape.BIG_TOP_SIDE_E)));
    }

    private boolean isAirSides(LevelAccessor world, BlockPos pos) {
        return world.m_46859_(pos.m_122012_()) && world.m_46859_(pos.m_122019_()) && world.m_46859_(pos.m_122029_()) && world.m_46859_(pos.m_122024_());
    }
}

